import {Component, OnInit} from '@angular/core';
import {CommonService} from '../common.service';
import {ActivatedRoute, Router} from "@angular/router";

@Component({
  selector: 'app-loan',
  templateUrl: './loan.component.html',
  styleUrls: ['./loan.component.css']
})
export class LoanComponent implements OnInit {
  curPageData: Array<any>;
  // 家庭结构
  type: any;
  pageAnswers: any;
  nextBtn: boolean;
  lastQuestions: Array<any>;
  targetObj:Object = {}
  constructor(private commonService: CommonService,
              private router: Router,
              private route: ActivatedRoute) {
    /**
     * 1:单身贵族
     * 2：二人世界
     * 3：独立带娃
     * 4：多口之家
     * @type {any}
     */
    this.type = this.route.snapshot.queryParams['type'];
    this.pageAnswers = {
      pageId: '',
      questions: [],
    };
  }

  ngOnInit() {
    this.nextBtn = false;
    this.lastQuestions = this.commonService.todosCopy.filter(item => item.pageId == 8).pop();    
    this.surveyInfo();
  }

  surveyInfo() {
    this.commonService.surveyInfo().then(res => {
      if (res['success']) {
        this.curPageData = res['data']['survey'].pages['7'];
        this.pageAnswers.pageId = this.curPageData['pageId'];
        for (let i = 0; i < this.lastQuestions['questions'].length; i++) {
          for (let j = 0; j < this.curPageData['questions'].length; j++) {
            if (this.lastQuestions['questions'][i].questionId == this.curPageData['questions'][j].questionId) {
             this.lastQuestions['questions'][i]['options'].forEach(option => {
               if(Object.keys(option).indexOf('optionId')>-1){
                 this.targetObj = option
               }
              this.selectedLoan(this.curPageData['questions'][j],this.targetObj);
              
             });
            }
          }
        }
      }
      console.log(this.pageAnswers)
      console.log(this.commonService.todos)
    })
  }

  selectedLoan(question, option) {
    option.selected = !option.selected;
    const questions = {
      questionId: question.questionId,
      questionName: question.questionName,
      options: []
    };
    if (question['options'].length > 0) {
      for (let j = 0; j < question['options'].length; j++) {
        if (question['options'][j].optionId == option.optionId) {
          question['options'][j].selected = true;
        } else {
          question['options'][j].selected = false;
        }
        // 拿到所有selected为true的选项
        if (question['options'][j]['selected']) {
          questions.options.push(question['options'][j]);
        }
      }
    }
    for (let i = 0; i < this.pageAnswers.questions.length; i++) {
      if (this.pageAnswers.questions[i].questionId == question.questionId) {
        const index = this.pageAnswers.questions.indexOf(this.pageAnswers.questions[i]);
        this.pageAnswers.questions.splice(index, 1);
      }
    }
    this.pageAnswers.questions.push(questions);
    this.commonService.addAnswer(this.pageAnswers);
    // console.log(this.pageAnswers)
    if (this.curPageData['questions'].length == this.pageAnswers['questions'].length) {
      this.nextBtn = true;
    } else {
      this.nextBtn = false;
    }
  }

  next() {
    if (this.nextBtn == true) {
      this.router.navigate(['/social'], {queryParams: {type: this.type}})
    } else {
      return;
    }
  }

  //  上一步
  before() {
    this.commonService.before();
  }
}
