import { Component, OnDestroy, OnInit } from '@angular/core';
import { EventBusService } from "./event-bus.service";
import { Subscription } from "rxjs/index";
declare const wx: any;
@Component({
  selector: 'app-root',
  templateUrl: './app.component.html',
  styleUrls: ['./app.component.css']
})

export class AppComponent implements OnInit, OnDestroy {
  shareGuidePageEnable: boolean;
  subscription: Subscription;
  constructor(public eventBusService: EventBusService) {
    this.subscription = eventBusService.shareStatus$.subscribe(status => {
      this.shareGuidePageEnable = status == '1';
    });
  }

  ngOnInit() {
    this.eventBusService.obtainToken().then(res => {
      if (res['success']) {
        localStorage.setItem('brokerQry', res['data']['token']);
        this.getWxConfig();
      }
    });
  }

  ngOnDestroy() {
    this.subscription.unsubscribe();
  }

  //  微信JS-SDK注册
  getWxConfig() {
    const url = encodeURIComponent(location.href.split('#')[0]);
    this.eventBusService.getWXJsInitConfig(url).then(res => {
      const data = res['data'];
      wx.config({
        debug: false,
        appId: data.appId,
        timestamp: data.timestamp,
        nonceStr: data.nonceStr,
        signature: data.signature,
        jsApiList: data.jsApiList,
        beta: true
      });
    });
  }
}
