import {Component, OnInit} from '@angular/core';
import {CommonService} from "./common.service";

@Component({
  selector: 'app-root',
  templateUrl: './app.component.html',
  styleUrls: ['./app.component.css']
})
export class AppComponent implements OnInit {

  constructor(private commonService: CommonService) {
  }

  ngOnInit() {
    let customerId = this.commonService.getQueryString('customerId');
    const double12_customerInfo = localStorage.getItem('double12_customerInfo') ? JSON.parse(localStorage.getItem('double12_customerInfo')) : null;
    if (double12_customerInfo) {
      customerId = double12_customerInfo.customerId;
    }
    const orderId = this.commonService.getQueryString('orderId');
    if (customerId) {
      sessionStorage.setItem('customerId', customerId);
    }
    if (orderId) {
      sessionStorage.setItem('orderId', orderId);
    }
    if (this.commonService.getQueryString('campaign') && this.commonService.getQueryString('task')) {
      const campaignInfo = {
        campaignCode: this.commonService.getQueryString('campaign'),
        campaignTaskCode: this.commonService.getQueryString('task'),
      };
      sessionStorage.setItem('campaignInfo', JSON.stringify(campaignInfo));
    }
    this.orderQuery(orderId);
  }

  //  查询是否已经支付成功
  orderQuery(orderId) {
    this.commonService.orderQuery(orderId).then(res => {
      if (res['success']) {
        sessionStorage.removeItem('campaignInfo');
      }
    });
  }
}
