import { Component, OnInit } from '@angular/core';
import { CommonService } from '../common.service'

@Component({
  selector: 'app-live',
  templateUrl: './live.component.html',
  styleUrls: ['./live.component.css']
})
export class LiveComponent implements OnInit {
  curPageData: Array<any>
  provinceList: Array<any>
  isShow: boolean
  provinceId: number
  provinceName: string
  cityList: Array<any>
  //页面是否显示地址
  showAddress: boolean
  //入参地址
  address: Object
  //页面地址
  strAddress: string
  constructor(
    private commonService: CommonService
  ) { }

  ngOnInit() {
    this.surveyInfo()
    this.showAddress = false;
  }
  surveyInfo() {
    //获取问题
    this.commonService.surveyInfo().then(res => {
      if (res['success']) {
        this.curPageData = res['data']['survey'].pages['15']
      }
    })
    //获取省份
    this.commonService.provinceqry({ insurerId: 11 }).then(res => {
      if (res['success']) {
        this.provinceList = res['data'].provinceList
      }
    })
  }

  showToast() {
    this.isShow = true
  }

  selectProvince(option) {
    // console.log(this.selectedProvinceObj)
    this.provinceName = option.provinceName
    this.provinceId = option.provinceId
    this.getCityqry()
  }
  closeToast() {
    this.isShow = false
  }

  getCityqry() {
    const param = {
      insurerId: 11,
      provinceId: this.provinceId
    }
    this.commonService.getCityqry(param).then(res => {
      if (res['success']) {
        this.cityList = res['data'].cityList
        // console.log(this.cityList)
      }
    })
  }

  selectCity(e) {
    this.showAddress = true
    this.strAddress = this.provinceName + e.cityName
    this.address = {
      customerInput: this.provinceName + ',' + e.cityName
    }
  }
}
