package com.yd.base.api.controller;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.yd.base.api.service.ApiRelFieldValueService;
import com.yd.base.feign.client.relfieldvalue.ApiRelFieldValueFeignClient;
import com.yd.base.feign.request.relfieldvalue.ApiRelFieldValuePageRequest;
import com.yd.base.feign.request.relfieldvalue.GetFieldListRequest;
import com.yd.base.feign.response.relfieldvalue.ApiRelFieldValuePageResponse;
import com.yd.base.feign.response.relfieldvalue.GetFieldListResponse;
import com.yd.common.result.Result;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.util.List;

/**
 * 字段和字段值关系信息
 *
 * @author zxm
 * @since 2025-11-21
 */
@RestController
@RequestMapping("/relFieldValue")
@Validated
public class ApiRelFieldValueController implements ApiRelFieldValueFeignClient {

    @Autowired
    private ApiRelFieldValueService apiRelFieldValueService;

    /**
     * 分页列表查询-字段和字段值关系信息
     * @param request
     * @return
     */
    @Override
    public Result<IPage<ApiRelFieldValuePageResponse>> page(ApiRelFieldValuePageRequest request) {
        return apiRelFieldValueService.page(request);
    }

    /**
     * 根据字段ID列表获取字段值列表
     * @return
     */
    @Override
    public Result<List<GetFieldListResponse>> getFieldList(GetFieldListRequest request) {
        return apiRelFieldValueService.getFieldList(request);
    }
}
