package com.yd.base.feign.client.relobjectcertificate;

import com.yd.base.feign.fallback.relobjectcertificate.ApiRelObjectCertificateFeignFallbackFactory;
import com.yd.base.feign.request.relobjectcertificate.ApiRelObjectCertificateListAddRequest;
import com.yd.base.feign.request.relobjectcertificate.ApiRelObjectCertificateListRequest;
import com.yd.base.feign.response.relobjectcertificate.ApiRelObjectCertificateListResponse;
import com.yd.common.result.Result;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import java.util.List;

/**
 * 基础数据服务-对象证件关系信息Feign客户端
 */
@FeignClient(name = "yd-base-api",path = "/base/api/relObjectCertificate",fallbackFactory = ApiRelObjectCertificateFeignFallbackFactory.class)
public interface ApiRelObjectCertificateFeignClient {

    /**
     * 列表查询-对象和分类关系
     * @param request
     * @return
     */
    @PostMapping("/list")
    Result<List<ApiRelObjectCertificateListResponse>> list(@Validated @RequestBody ApiRelObjectCertificateListRequest request);

    /**
     * 添加-单个对象和分类列表关系
     * @param request
     * @return
     */
    @PostMapping("/add/relObjectCertificateList")
    Result addRelObjectCertificateList(@Validated @RequestBody ApiRelObjectCertificateListAddRequest request);
}
