package com.yd.base.feign.fallback.relobjectcertificate;

import com.yd.base.feign.client.relobjectcertificate.ApiRelObjectCertificateFeignClient;
import com.yd.base.feign.request.relobjectcertificate.ApiRelObjectCertificateListAddRequest;
import com.yd.base.feign.request.relobjectcertificate.ApiRelObjectCertificateListRequest;
import com.yd.base.feign.response.relobjectcertificate.ApiRelObjectCertificateListResponse;
import com.yd.common.result.Result;
import lombok.extern.slf4j.Slf4j;
import org.springframework.cloud.openfeign.FallbackFactory;
import org.springframework.stereotype.Component;

import java.util.List;

/**
 * 基础数据服务-对象证件关系信息Feign降级处理
 */
@Slf4j
@Component
public class ApiRelObjectCertificateFeignFallbackFactory implements FallbackFactory<ApiRelObjectCertificateFeignClient> {
    @Override
    public ApiRelObjectCertificateFeignClient create(Throwable cause) {
        return new ApiRelObjectCertificateFeignClient() {
            @Override
            public Result<List<ApiRelObjectCertificateListResponse>> list(ApiRelObjectCertificateListRequest request) {
                return null;
            }

            @Override
            public Result addRelObjectCertificateList(ApiRelObjectCertificateListAddRequest request) {
                return null;
            }
        };
    }
}
