package com.yd.base.feign.request.relobjectcertificate;

import com.yd.base.feign.dto.ApiCertificateDto;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import javax.validation.constraints.NotBlank;
import java.util.List;

@Data
@Builder
@NoArgsConstructor
@AllArgsConstructor
public class ApiRelObjectCertificateListAddRequest {

    /**
     * 业务对象类型
     */
    private String objectType;

    /**
     * 业务对象所属表名
     */
    private String objectTableName;

    /**
     * 业务对象名
     */
    private String objectName;

    /**
     * 业务对象业务ID
     */
    @NotBlank(message = "业务对象业务ID不能为空")
    private String objectBizId;

    /**
     * 证件信息列表
     */
    private List<ApiCertificateDto> apiCertificateDtoList;
}
