package com.yd.base.api.service.impl;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yd.base.api.service.ApiFieldService;
import com.yd.base.feign.request.field.ApiFieldAddRequest;
import com.yd.base.feign.request.field.ApiFieldEditRequest;
import com.yd.base.feign.request.field.ApiFieldPageRequest;
import com.yd.base.feign.response.field.ApiFieldDetailResponse;
import com.yd.base.feign.response.field.ApiFieldPageResponse;
import com.yd.base.service.dto.FieldDto;
import com.yd.base.service.model.Field;
import com.yd.base.service.service.IFieldService;
import com.yd.common.constant.CodeGeneratorConstants;
import com.yd.common.enums.CommonEnum;
import com.yd.common.exception.BusinessException;
import com.yd.common.result.Result;
import com.yd.common.utils.CodeGenerator;
import com.yd.common.utils.RandomStringGenerator;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import java.util.Objects;

@Slf4j
@Service
public class ApiFieldServiceImpl implements ApiFieldService {

    @Autowired
    private IFieldService iFieldService;

    /**
     * 分页列表查询-字段
     * @param request
     * @return
     */
    @Override
    public Result<IPage<ApiFieldPageResponse>> page(ApiFieldPageRequest request) {
        Page<ApiFieldPageResponse> page = new Page<>(request.getPageNo(), request.getPageSize());
        IPage<ApiFieldPageResponse> iPage = iFieldService.page(page, request);
        return Result.success(iPage);
    }

    /**
     * 添加-字段
     * @param request
     * @return
     */
    @Override
    public Result add(ApiFieldAddRequest request) {
        Field field = new Field();
        BeanUtils.copyProperties(request,field);
        //字段表唯一业务ID
        field.setFieldBizId(RandomStringGenerator.generateBizId16(CommonEnum.UID_TYPE_FIELD.getCode()));
        //字段编码
        field.setFieldCode(CodeGenerator.generate10Code(CodeGeneratorConstants.PREFIX_FIELD_CODE));
        iFieldService.saveOrUpdate(field);
        return Result.success();
    }

    /**
     * 编辑-字段
     * @param request
     * @return
     */
    @Override
    public Result edit(ApiFieldEditRequest request) {
        //查询字段信息是否存在
        Result<Field> result = checkFieldIsExist(request.getFieldBizId());
        Field field = result.getData();
        BeanUtils.copyProperties(request,field);
        iFieldService.saveOrUpdate(field);
        return Result.success();
    }

    /**
     * 详情-字段
     * @param fieldBizId 字段表唯一业务ID
     * @return
     */
    @Override
    public Result<ApiFieldDetailResponse> detail(String fieldBizId) {
        //查询字段信息是否存在
        Result<Field> result = checkFieldIsExist(fieldBizId);
        Field field = result.getData();
        ApiFieldDetailResponse response = new ApiFieldDetailResponse();
        BeanUtils.copyProperties(field,response);
        return Result.success(response);
    }

    /**
     * 删除-字段
     * @param fieldBizId 字段表唯一业务ID
     * @return
     */
    @Override
    public Result del(String fieldBizId) {
        return null;
    }

    /**
     * 校验字段信息是否存在
     * @param fieldBizId
     * @return
     */
    public Result<Field> checkFieldIsExist(String fieldBizId) {
        Field field = iFieldService.queryOne(FieldDto.builder().fieldBizId(fieldBizId).build());
        if (Objects.isNull(field)) {
            //数据不存在
            throw new BusinessException("字段信息不存在");
        }
        return Result.success(field);
    }
}
