package com.yd.base.api.controller;

import com.yd.base.api.service.ApiRelObjectCategoryService;
import com.yd.base.feign.client.relobjectcategory.ApiRelObjectCategoryFeignClient;
import com.yd.base.feign.request.relobjectcategory.ApiRelCategoryObjectListAddRequest;
import com.yd.base.feign.request.relobjectcategory.ApiRelObjectCategoryListAddRequest;
import com.yd.base.feign.request.relobjectcategory.ApiRelObjectCategoryQueryRequest;
import com.yd.base.feign.request.relobjectcategory.ApiRelObjectCategoryQuerySelectedRequest;
import com.yd.base.feign.response.relobjectcategory.ApiRelObjectCategoryQueryResponse;
import com.yd.base.feign.response.relobjectcategory.ApiRelObjectCategoryQuerySelectedResponse;
import com.yd.common.result.Result;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import java.util.List;

/**
 * 对象分类关系信息
 *
 * @author zxm
 * @since 2025-11-20
 */
@RestController
@RequestMapping("/relObjectCategory")
@Validated
public class ApiRelObjectCategoryController implements ApiRelObjectCategoryFeignClient {

    @Autowired
    private ApiRelObjectCategoryService apiRelObjectCategoryService;

    /**
     * 查询-对象分类关系列表
     * @param request
     * @return
     */
    @Override
    public Result<List<ApiRelObjectCategoryQueryResponse>> query(ApiRelObjectCategoryQueryRequest request) {
        return apiRelObjectCategoryService.query(request);
    }

    /**
     * 查询-选中的分类列表
     * @param request
     * @return
     */
    @Override
    public Result<List<ApiRelObjectCategoryQuerySelectedResponse>> querySelected(ApiRelObjectCategoryQuerySelectedRequest request) {
        return apiRelObjectCategoryService.querySelected(request);
    }

    /**
     * 添加-单个对象和分类列表关系
     * @param request
     * @return
     */
    @Override
    public Result addRelObjectCategoryList(ApiRelObjectCategoryListAddRequest request) {
        return apiRelObjectCategoryService.addRelObjectCategoryList(request);
    }

    /**
     * 添加-单个分类和对象列表关系
     * @param request
     * @return
     */
    @Override
    public Result addRelCategoryObjectList(ApiRelCategoryObjectListAddRequest request) {
        return apiRelObjectCategoryService.addRelCategoryObjectList(request);
    }

}
