package com.yd.base.feign.fallback.fieldvalue;

import com.yd.base.feign.client.fieldvalue.ApiFieldValueFeignClient;
import com.yd.base.feign.request.fieldvalue.ApiFieldValueAddRequest;
import com.yd.base.feign.request.fieldvalue.ApiFieldValueEditRequest;
import com.yd.base.feign.request.fieldvalue.ApiFieldValuePageRequest;
import com.yd.base.feign.response.fieldvalue.ApiFieldValueDetailResponse;
import com.yd.common.result.Result;
import lombok.extern.slf4j.Slf4j;
import org.springframework.cloud.openfeign.FallbackFactory;
import org.springframework.stereotype.Component;

/**
 * 基础数据服务-字段值信息Feign降级处理
 */
@Slf4j
@Component
public class ApiFieldValueFeignFallbackFactory implements FallbackFactory<ApiFieldValueFeignClient> {
    @Override
    public ApiFieldValueFeignClient create(Throwable cause) {
        return new ApiFieldValueFeignClient() {
            @Override
            public Result page(ApiFieldValuePageRequest request) {
                return null;
            }

            @Override
            public Result add(ApiFieldValueAddRequest request) {
                return null;
            }

            @Override
            public Result edit(ApiFieldValueEditRequest request) {
                return null;
            }

            @Override
            public Result<ApiFieldValueDetailResponse> detail(String fieldValueBizId) {
                return null;
            }

            @Override
            public Result del(String fieldValueBizId) {
                return null;
            }
        };
    }
}
