package com.yd.base.api.controller;

import com.yd.base.api.service.ApiRelObjectSpeciesService;
import com.yd.base.feign.client.relobjectspecies.ApiRelObjectSpeciesFeignClient;
import com.yd.base.feign.request.relobjectspecies.ApiRelObjectSpeciesListAddRequest;
import com.yd.base.feign.request.relobjectspecies.ApiRelObjectSpeciesQueryRequest;
import com.yd.base.feign.response.relobjectspecies.ApiRelObjectSpeciesQueryResponse;
import com.yd.common.result.Result;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.util.List;

/**
 * 对象规格关系信息
 *
 * @author zxm
 * @since 2025-11-20
 */
@RestController
@RequestMapping("/relObjectSpecies")
@Validated
public class ApiRelObjectSpeciesController implements ApiRelObjectSpeciesFeignClient {

    @Autowired
    private ApiRelObjectSpeciesService apiRelObjectSpeciesService;

    /**
     * 查询-对象规格关系列表
     * @param request
     * @return
     */
    @Override
    public Result<List<ApiRelObjectSpeciesQueryResponse>> query(ApiRelObjectSpeciesQueryRequest request) {
        return apiRelObjectSpeciesService.query(request);
    }

    /**
     * 添加-单个对象和规格列表关系
     * @param request
     * @return
     */
    @Override
    public Result addRelObjectSpeciesList(ApiRelObjectSpeciesListAddRequest request) {
        return apiRelObjectSpeciesService.addRelObjectSpeciesList(request);
    }
}
