package com.yd.base.feign.fallback.exchangerate;

import com.yd.base.feign.client.exchangerate.ApiExchangeRateFeignClient;
import com.yd.base.feign.request.exchangerate.ApiExchangeRateConvertRequest;
import com.yd.base.feign.response.exchangerate.ApiExchangeRateConvertResponse;
import com.yd.common.result.Result;
import lombok.extern.slf4j.Slf4j;
import org.springframework.cloud.openfeign.FallbackFactory;
import org.springframework.stereotype.Component;

import java.math.BigDecimal;
import java.util.List;

/**
 * 基础数据服务-汇率信息Feign降级处理
 */
@Slf4j
@Component
public class ApiExchangeRateFeignFallbackFactory implements FallbackFactory<ApiExchangeRateFeignClient> {
    @Override
    public ApiExchangeRateFeignClient create(Throwable cause) {
        return new ApiExchangeRateFeignClient() {
            @Override
            public Result<ApiExchangeRateConvertResponse> convert(ApiExchangeRateConvertRequest request) {
                return null;
            }

            @Override
            public Result<BigDecimal> getExchangeRate(String baseCurrency, String targetCurrency, String date) {
                return null;
            }

            @Override
            public Result<List<ApiExchangeRateConvertResponse>> batchConvert(List<ApiExchangeRateConvertRequest> requests) {
                return null;
            }

            @Override
            public Result<Boolean> isCurrencySupportedResult(String currency) {
                return null;
            }

            @Override
            public Result<List<String>> getSupportedCurrencies() {
                return null;
            }
        };
    }
}
