package com.yd.base.service.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.yd.base.service.model.ExchangeRate;
import com.yd.base.service.dao.ExchangeRateMapper;
import com.yd.base.service.service.IExchangeRateService;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import org.springframework.stereotype.Service;

import java.time.LocalDate;
import java.util.List;

/**
 * <p>
 * 汇率表 服务实现类
 * </p>
 *
 * @author zxm
 * @since 2025-12-29
 */
@Service
public class ExchangeRateServiceImpl extends ServiceImpl<ExchangeRateMapper, ExchangeRate> implements IExchangeRateService {

    @Override
    public ExchangeRate getByCurrencyAndDate(String baseCurrency, String targetCurrency, LocalDate effectiveDate) {
        LambdaQueryWrapper<ExchangeRate> queryWrapper = new LambdaQueryWrapper<>();
        queryWrapper.eq(ExchangeRate::getBaseCurrency, baseCurrency)
                .eq(ExchangeRate::getTargetCurrency, targetCurrency)
                .eq(ExchangeRate::getEffectiveDate, effectiveDate)
                .eq(ExchangeRate::getIsActive, 1)
                .eq(ExchangeRate::getIsDeleted, 0)
                .last("LIMIT 1");

        return this.getOne(queryWrapper);
    }

    @Override
    public ExchangeRate getLatestByCurrency(String baseCurrency, String targetCurrency) {
        LambdaQueryWrapper<ExchangeRate> queryWrapper = new LambdaQueryWrapper<>();
        queryWrapper.eq(ExchangeRate::getBaseCurrency, baseCurrency)
                .eq(ExchangeRate::getTargetCurrency, targetCurrency)
                .eq(ExchangeRate::getIsActive, 1)
                .eq(ExchangeRate::getIsDeleted, 0)
                .orderByDesc(ExchangeRate::getEffectiveDate)
                .last("LIMIT 1");

        return this.getOne(queryWrapper);
    }

    @Override
    public List<ExchangeRate> getByEffectiveDate(LocalDate effectiveDate) {
        LambdaQueryWrapper<ExchangeRate> queryWrapper = new LambdaQueryWrapper<>();
        queryWrapper.eq(ExchangeRate::getEffectiveDate, effectiveDate)
                .eq(ExchangeRate::getIsActive, 1)
                .eq(ExchangeRate::getIsDeleted, 0);

        return this.list(queryWrapper);
    }

    @Override
    public List<ExchangeRate> getAllActiveRates() {
        LambdaQueryWrapper<ExchangeRate> queryWrapper = new LambdaQueryWrapper<>();
        queryWrapper.eq(ExchangeRate::getIsActive, 1)
                .eq(ExchangeRate::getIsDeleted, 0)
                .orderByAsc(ExchangeRate::getBaseCurrency)
                .orderByAsc(ExchangeRate::getTargetCurrency);

        return this.list(queryWrapper);
    }

    @Override
    public List<ExchangeRate> getByBaseCurrency(String baseCurrency) {
        LambdaQueryWrapper<ExchangeRate> queryWrapper = new LambdaQueryWrapper<>();
        queryWrapper.eq(ExchangeRate::getBaseCurrency, baseCurrency)
                .eq(ExchangeRate::getIsActive, 1)
                .eq(ExchangeRate::getIsDeleted, 0)
                .orderByAsc(ExchangeRate::getTargetCurrency);

        return this.list(queryWrapper);
    }

    @Override
    public List<ExchangeRate> getByTargetCurrency(String targetCurrency) {
        LambdaQueryWrapper<ExchangeRate> queryWrapper = new LambdaQueryWrapper<>();
        queryWrapper.eq(ExchangeRate::getTargetCurrency, targetCurrency)
                .eq(ExchangeRate::getIsActive, 1)
                .eq(ExchangeRate::getIsDeleted, 0)
                .orderByAsc(ExchangeRate::getBaseCurrency);

        return this.list(queryWrapper);
    }
}