package com.yd.base.service.model;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import java.io.Serializable;
import java.time.LocalDateTime;
import lombok.Getter;
import lombok.Setter;

/**
 * <p>
 * 对象证件关系表
 * </p>
 *
 * @author zxm
 * @since 2026-02-02
 */
@Getter
@Setter
@TableName("rel_object_certificate")
public class RelObjectCertificate implements Serializable {

    private static final long serialVersionUID = 1L;

    /**
     * 主键ID
     */
    @TableId(value = "id", type = IdType.AUTO)
    private Long id;

    /**
     * 对象证件关系表唯一业务ID
     */
    @TableField("rel_object_certificate_biz_id")
    private String relObjectCertificateBizId;

    /**
     * 业务对象类型
     */
    @TableField("object_type")
    private String objectType;

    /**
     * 业务对象所属表名
     */
    @TableField("object_table_name")
    private String objectTableName;

    /**
     * 业务对象名
     */
    @TableField("object_name")
    private String objectName;

    /**
     * 业务对象业务ID
     */
    @TableField("object_biz_id")
    private String objectBizId;

    /**
     * 证件类型
     */
    @TableField("document_type")
    private String documentType;

    /**
     * 证件号码
     */
    @TableField("id_number")
    private String idNumber;

    /**
     * 证件签发日期
     */
    @TableField("certificate_issue_date")
    private LocalDateTime certificateIssueDate;

    /**
     * 证件有效期开始日期
     */
    @TableField("certificate_start_date")
    private LocalDateTime certificateStartDate;

    /**
     * 证件有效期截止日期，NULL表示长期有效
     */
    @TableField("certificate_end_date")
    private LocalDateTime certificateEndDate;

    /**
     * 是否长期有效：0-否，1-是
     */
    @TableField("is_permanent")
    private Integer isPermanent;

    /**
     * 通用备注
     */
    @TableField("remark")
    private String remark;

    /**
     * 删除标识: 0-正常, 1-删除
     */
    @TableField("is_deleted")
    private Integer isDeleted;

    /**
     * 创建人ID
     */
    @TableField("creator_id")
    private String creatorId;

    /**
     * 更新人ID
     */
    @TableField("updater_id")
    private String updaterId;

    /**
     * 创建时间
     */
    @TableField("create_time")
    private LocalDateTime createTime;

    /**
     * 更新时间
     */
    @TableField("update_time")
    private LocalDateTime updateTime;
}
