package com.yd.base.service.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.yd.base.service.model.RelObjectCertificate;
import com.yd.base.service.dao.RelObjectCertificateMapper;
import com.yd.base.service.service.IRelObjectCertificateService;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import org.springframework.stereotype.Service;

import java.util.List;

/**
 * <p>
 * 对象证件关系表 服务实现类
 * </p>
 *
 * @author zxm
 * @since 2026-02-02
 */
@Service
public class RelObjectCertificateServiceImpl extends ServiceImpl<RelObjectCertificateMapper, RelObjectCertificate> implements IRelObjectCertificateService {

    @Override
    public List<RelObjectCertificate> list(String objectBizId) {
        return baseMapper.selectList(new LambdaQueryWrapper<RelObjectCertificate>()
                .eq(RelObjectCertificate::getObjectBizId,objectBizId));
    }

    @Override
    public Boolean delByObjectBizId(String objectBizId) {
        return this.remove(new LambdaQueryWrapper<RelObjectCertificate>()
                .eq(RelObjectCertificate::getObjectBizId,objectBizId));
    }
}
