package com.yd.base.feign.client.fieldvalue;

import com.yd.base.feign.fallback.fieldvalue.ApiFieldValueFeignFallbackFactory;
import com.yd.base.feign.request.fieldvalue.ApiFieldValueAddRequest;
import com.yd.base.feign.request.fieldvalue.ApiFieldValueEditRequest;
import com.yd.base.feign.request.fieldvalue.ApiFieldValuePageRequest;
import com.yd.base.feign.response.fieldvalue.ApiFieldValueDetailResponse;
import com.yd.common.result.Result;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;
import javax.validation.constraints.NotBlank;

/**
 * 基础数据服务-字段值值信息Feign客户端
 */
@FeignClient(name = "yd-base-api", fallbackFactory = ApiFieldValueFeignFallbackFactory.class)
public interface ApiFieldValueFeignClient {

    /**
     * 分页列表查询-字段值
     * @param request
     * @return
     */
    @PostMapping("/page")
    Result page(@RequestBody ApiFieldValuePageRequest request);

    /**
     * 添加-字段值
     * @param request
     * @return
     */
    @PostMapping("/add")
    Result add(@Validated @RequestBody ApiFieldValueAddRequest request);

    /**
     * 编辑-字段值
     * @param request
     * @return
     */
    @PutMapping("/edit")
    Result edit(@Validated @RequestBody ApiFieldValueEditRequest request);

    /**
     * 详情-字段值
     * @param fieldValueBizId 字段值表唯一业务ID
     * @return
     */
    @GetMapping("/detail")
    Result<ApiFieldValueDetailResponse> detail(@NotBlank(message = "字段值表唯一业务ID能为空") @RequestParam(value = "fieldValueBizId") String fieldValueBizId);

    /**
     * 删除-字段值
     * @param fieldValueBizId 字段值表唯一业务ID
     * @return
     */
    @DeleteMapping("/del")
    Result del(@NotBlank(message = "字段值表唯一业务ID能为空") @RequestParam(value = "fieldValueBizId") String fieldValueBizId);
}
