package com.yd.base.feign.request.relobjectfield;

import com.yd.base.feign.dto.ApiObjectFieldValueDto;
import lombok.Data;
import javax.validation.constraints.NotBlank;
import java.util.List;

@Data
public class ApiRelObjectFieldListAddRequest {

    /**
     * 业务对象类型
     */
    @NotBlank(message = "业务对象类型不能为空")
    private String objectType;

    /**
     * 业务对象所属表名（产品表、活动表、资讯表、期刊表等）
     */
    @NotBlank(message = "业务对象所属表名不能为空")
    private String objectTableName;

    /**
     * 业务对象名
     */
    private String objectName;

    /**
     * 业务对象业务ID
     */
    @NotBlank(message = "业务对象业务ID不能为空")
    private String objectBizId;

    /**
     * 对象字段录入值信息列表
     */
    private List<ApiObjectFieldValueDto> apiObjectFieldValueDtoList;
}
