package com.yd.base.feign.response.relobjectfield;

import lombok.Data;

@Data
public class ApiRelObjectFieldQueryResponse {

    //=======对象字段关系信息start=======
    /**
     * 对象字段关系主键ID
     */
    private Long relObjectFieldId;

    /**
     * 对象类型
     */
    private String objectType;

    /**
     * 对象所属表名（产品表等）
     */
    private String objectTableName;

    /**
     * 对象名
     */
    private String objectName;

    /**
     * 对象业务ID
     */
    private String objectBizId;

    /**
     * 字段值表唯一业务ID
     */
    private String fieldValueBizId;

    /**
     * 字段值（填写的值）
     */
    private String value;
    //=======对象字段关系信息end=======


    //=======字段信息start=======
    /**
     * 字段表唯一业务ID
     */
    private String fieldBizId;

    /**
     * 字段编码（唯一标识）
     */
    private String fieldCode;

    /**
     * 字段中文名称
     */
    private String fieldCnName;

    /**
     * 字段英文名称
     */
    private String fieldEnName;

    /**
     * 字段数据类型（varchar/int/decimal/date/datetime/text等）
     */
    private String fieldType;

    /**
     * 字段长度
     */
    private Integer fieldLength;

    /**
     * 字段精度（针对decimal类型）
     */
    private Integer fieldPrecision;

    /**
     * 是否必填：0-否，1-是
     */
    private Integer isRequired;

    /**
     * 默认值
     */
    private String defaultValue;

    /**
     * 字段排序
     */
    private Integer fieldOrder;

    /**
     * 文本框类型
     */
    private String textBoxType;
    //=======字段信息end=======
}
