/*
 * Decompiled with CFR 0.152.
 */
package com.yd.base.api.service.impl;

import com.yd.base.api.service.ApiRelObjectSpeciesService;
import com.yd.base.feign.request.relobjectspecies.ApiRelObjectSpeciesListAddRequest;
import com.yd.base.feign.request.relobjectspecies.ApiRelObjectSpeciesQueryRequest;
import com.yd.base.feign.response.relobjectspecies.ApiRelObjectSpeciesQueryResponse;
import com.yd.base.service.model.RelObjectSpecies;
import com.yd.base.service.service.IRelObjectSpeciesService;
import com.yd.common.result.Result;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class ApiRelObjectSpeciesServiceImpl
implements ApiRelObjectSpeciesService {
    private static final Logger log = LoggerFactory.getLogger(ApiRelObjectSpeciesServiceImpl.class);
    @Autowired
    private IRelObjectSpeciesService iRelObjectSpeciesService;

    @Override
    public Result<List<ApiRelObjectSpeciesQueryResponse>> query(ApiRelObjectSpeciesQueryRequest request) {
        List responses = this.iRelObjectSpeciesService.query(request);
        return Result.success((Object)responses);
    }

    @Override
    public Result addRelObjectSpeciesList(ApiRelObjectSpeciesListAddRequest request) {
        this.iRelObjectSpeciesService.delByObjectBizId(request.getObjectBizId());
        if (!CollectionUtils.isEmpty((Collection)request.getSpeciesTypeBizIdList())) {
            List relObjectSpeciesList = request.getSpeciesTypeBizIdList().stream().map(bizId -> {
                RelObjectSpecies relObjectSpecies = new RelObjectSpecies();
                BeanUtils.copyProperties((Object)request, (Object)relObjectSpecies);
                relObjectSpecies.setSpeciesTypeBizId(bizId);
                return relObjectSpecies;
            }).collect(Collectors.toList());
            this.iRelObjectSpeciesService.saveOrUpdateBatch(relObjectSpeciesList);
        }
        return Result.success();
    }
}

