package com.yd.base.api.service.impl;

import com.yd.base.api.service.ApiRelFieldValueService;
import com.yd.base.service.model.RelFieldValue;
import com.yd.base.service.service.IRelFieldValueService;
import com.yd.common.result.Result;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import java.util.List;
import java.util.stream.Collectors;

@Slf4j
@Service
public class ApiRelFieldValueServiceImpl implements ApiRelFieldValueService {

    @Autowired
    private IRelFieldValueService iRelFieldValueService;

    /**
     * 保存字段值和字段的关系
     * @param fieldValueBizId
     * @param fieldBizIdList
     * @return
     */
    @Override
    public Result save(String fieldValueBizId, List<String> fieldBizIdList) {
        //先删后新增
        //根据字段值业务ID删除关系
        iRelFieldValueService.delByFieldValueBizId(fieldValueBizId);

        //新增
        if (!CollectionUtils.isEmpty(fieldBizIdList)) {
            List<RelFieldValue> relFieldValueList = fieldBizIdList.stream().map(fieldBizId -> {
                RelFieldValue relFieldValue = new RelFieldValue();
                relFieldValue.setFieldBizId(fieldBizId);
                relFieldValue.setFieldValueBizId(fieldValueBizId);
                return relFieldValue;
            }).collect(Collectors.toList());

            iRelFieldValueService.saveOrUpdateBatch(relFieldValueList);
        }
        return Result.success();
    }
}
