package com.yd.base.service.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.yd.base.feign.request.species.ApiSpeciesPageRequest;
import com.yd.base.feign.response.species.ApiSpeciesPageResponse;
import com.yd.base.service.dao.SpeciesMapper;
import com.yd.base.service.dto.SpeciesDto;
import com.yd.base.service.model.Category;
import com.yd.base.service.model.Species;
import com.yd.base.service.service.ISpeciesService;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;

import java.util.List;

/**
 * <p>
 * 规格表 服务实现类
 * </p>
 *
 * @author zxm
 * @since 2025-11-20
 */
@Service
public class SpeciesServiceImpl extends ServiceImpl<SpeciesMapper, Species> implements ISpeciesService {

    @Override
    public IPage<ApiSpeciesPageResponse> page(Page<ApiSpeciesPageResponse> page,
                                              ApiSpeciesPageRequest request) {
        return baseMapper.page(page,request);
    }

    /**
     * 查询列表
     * @param dto
     * @return
     */
    @Override
    public List<Species> queryList(SpeciesDto dto) {
        List<Species> list = baseMapper.selectList(new LambdaQueryWrapper<Species>()
                .eq(StringUtils.isNotBlank(dto.getSpeciesBizId()) && !dto.getIsExcludeMy(),Species::getSpeciesBizId,dto.getSpeciesBizId())
                .eq(StringUtils.isNotBlank(dto.getValue()),Species::getValue,dto.getValue())
                .ne(dto.getIsExcludeMy(),Species::getSpeciesBizId,dto.getSpeciesBizId())
        );
        return list;
    }

    /**
     * 查询单个对象
     * @param speciesBizId
     * @return
     */
    @Override
    public Species queryOne(String speciesBizId) {
        return this.getOne(new LambdaQueryWrapper<Species>().eq(Species::getSpeciesBizId,speciesBizId));
    }
}
