package com.yd.base.feign.client.category;

import com.yd.common.result.Result;
import com.yd.base.feign.fallback.category.ApiCategoryFeignFallbackFactory;
import com.yd.base.feign.request.category.ApiCategoryAddRequest;
import com.yd.base.feign.request.category.ApiCategoryEditRequest;
import com.yd.base.feign.request.category.ApiCategoryPageRequest;
import com.yd.base.feign.request.category.ApiCategoryTreeListRequest;
import com.yd.base.feign.response.category.ApiCategoryDetailResponse;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;

import javax.validation.constraints.NotBlank;

/**
 * 基础数据服务-分类信息Feign客户端
 */
@FeignClient(name = "yd-base-api", fallbackFactory = ApiCategoryFeignFallbackFactory.class)
public interface ApiCategoryFeignClient {

    /**
     * 分页列表查询-分类
     * @param request
     * @return
     */
    @PostMapping("/page")
    Result page(@RequestBody ApiCategoryPageRequest request);

    /**
     * 树形列表查询-分类
     * @param request
     * @return
     */
    @PostMapping("/tree/list")
    Result treeList(@RequestBody ApiCategoryTreeListRequest request);

    /**
     * 添加-分类
     * @param request
     * @return
     */
    @PostMapping("/add")
    Result add(@Validated @RequestBody ApiCategoryAddRequest request);

    /**
     * 编辑-分类
     * @param request
     * @return
     */
    @PutMapping("/edit")
    Result edit(@Validated @RequestBody ApiCategoryEditRequest request);

    /**
     * 详情-分类
     * @param categoryBizId 分类表唯一业务ID
     * @return
     */
    @GetMapping("/detail")
    Result<ApiCategoryDetailResponse> detail(@NotBlank(message = "分类表唯一业务ID能为空") @RequestParam(value = "categoryBizId") String categoryBizId);

    /**
     * 删除-分类
     * @param categoryBizId 分类表唯一业务ID
     * @return
     */
    @DeleteMapping("/del")
    Result del(@NotBlank(message = "分类表唯一业务ID能为空") @RequestParam(value = "categoryBizId") String categoryBizId);
}
