/*
 * Decompiled with CFR 0.152.
 */
package com.yd.base.api.service.impl;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yd.base.api.service.ApiFieldValueService;
import com.yd.base.api.service.ApiRelFieldValueService;
import com.yd.base.feign.request.fieldvalue.ApiFieldValueAddRequest;
import com.yd.base.feign.request.fieldvalue.ApiFieldValueEditRequest;
import com.yd.base.feign.request.fieldvalue.ApiFieldValuePageRequest;
import com.yd.base.feign.response.fieldvalue.ApiFieldValueDetailResponse;
import com.yd.base.feign.response.fieldvalue.ApiFieldValuePageResponse;
import com.yd.base.service.dto.FieldValueDto;
import com.yd.base.service.model.FieldValue;
import com.yd.base.service.service.IFieldValueService;
import com.yd.common.enums.CommonEnum;
import com.yd.common.exception.BusinessException;
import com.yd.common.result.Result;
import com.yd.common.utils.CodeGenerator;
import com.yd.common.utils.RandomStringGenerator;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class ApiFieldValueServiceImpl
implements ApiFieldValueService {
    private static final Logger log = LoggerFactory.getLogger(ApiFieldValueServiceImpl.class);
    @Autowired
    private IFieldValueService iFieldValueService;
    @Autowired
    private ApiRelFieldValueService apiRelFieldValueService;

    @Override
    public Result<IPage<ApiFieldValuePageResponse>> page(ApiFieldValuePageRequest request) {
        Page page = new Page((long)request.getPageNo().intValue(), (long)request.getPageSize().intValue());
        IPage iPage = this.iFieldValueService.page(page, request);
        return Result.success((Object)iPage);
    }

    @Override
    public Result add(ApiFieldValueAddRequest request) {
        List fieldValueList = this.iFieldValueService.queryList(FieldValueDto.builder().value(request.getValue()).build());
        if (!CollectionUtils.isEmpty((Collection)fieldValueList)) {
            throw new BusinessException("\u5b57\u6bb5\u503c\u5df2\u5b58\u5728");
        }
        FieldValue fieldValue = new FieldValue();
        BeanUtils.copyProperties((Object)request, (Object)fieldValue);
        fieldValue.setFieldValueBizId(RandomStringGenerator.generateBizId16((String)CommonEnum.UID_TYPE_FIELD_VALUE.getCode()));
        fieldValue.setFieldValueCode(CodeGenerator.generate10Code((String)"FIELD_VALUE"));
        this.iFieldValueService.saveOrUpdate((Object)fieldValue);
        this.apiRelFieldValueService.save(fieldValue.getFieldValueBizId(), request.getFieldBizIdList());
        return Result.success();
    }

    @Override
    public Result edit(ApiFieldValueEditRequest request) {
        Result<FieldValue> result = this.checkFieldValueIsExist(request.getFieldValueBizId());
        FieldValue fieldValue = (FieldValue)result.getData();
        List fieldValueList = this.iFieldValueService.queryList(FieldValueDto.builder().value(request.getValue()).fieldValueBizId(request.getFieldValueBizId()).isExcludeMy(Boolean.valueOf(true)).build());
        if (!CollectionUtils.isEmpty((Collection)fieldValueList)) {
            throw new BusinessException("\u5b57\u6bb5\u503c\u5df2\u5b58\u5728");
        }
        BeanUtils.copyProperties((Object)request, (Object)fieldValue);
        this.iFieldValueService.saveOrUpdate((Object)fieldValue);
        this.apiRelFieldValueService.save(fieldValue.getFieldValueBizId(), request.getFieldBizIdList());
        return Result.success();
    }

    @Override
    public Result<ApiFieldValueDetailResponse> detail(String fieldValueBizId) {
        Result<FieldValue> result = this.checkFieldValueIsExist(fieldValueBizId);
        FieldValue fieldValue = (FieldValue)result.getData();
        ApiFieldValueDetailResponse response = new ApiFieldValueDetailResponse();
        BeanUtils.copyProperties((Object)fieldValue, (Object)response);
        return Result.success((Object)response);
    }

    @Override
    public Result del(String fieldValueBizId) {
        return null;
    }

    public Result<FieldValue> checkFieldValueIsExist(String fieldValueBizId) {
        FieldValue fieldValue = this.iFieldValueService.queryOne(fieldValueBizId);
        if (Objects.isNull(fieldValue)) {
            throw new BusinessException("\u5b57\u6bb5\u503c\u6570\u636e\u4e0d\u5b58\u5728");
        }
        return Result.success((Object)fieldValue);
    }
}

