package com.yd.base.api.service.impl;

import com.yd.base.api.service.ApiRelObjectCategoryService;
import com.yd.base.feign.request.relobjectcategory.ApiRelCategoryObjectListAddRequest;
import com.yd.base.feign.request.relobjectcategory.ApiRelObjectCategoryListAddRequest;
import com.yd.base.feign.request.relobjectcategory.ApiRelObjectCategoryQueryRequest;
import com.yd.base.feign.response.relobjectcategory.ApiRelObjectCategoryQueryResponse;
import com.yd.base.service.model.RelObjectCategory;
import com.yd.base.service.service.IRelObjectCategoryService;
import com.yd.common.result.Result;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import java.util.List;
import java.util.stream.Collectors;

@Slf4j
@Service
public class ApiRelObjectCategoryServiceImpl implements ApiRelObjectCategoryService {

    @Autowired
    private IRelObjectCategoryService iRelObjectCategoryService;

    /**
     * 查询-对象分类关系列表
     * @param request
     * @return
     */
    @Override
    public Result<List<ApiRelObjectCategoryQueryResponse>> query(ApiRelObjectCategoryQueryRequest request) {
        List<ApiRelObjectCategoryQueryResponse> responses = iRelObjectCategoryService.query(request);
        return Result.success(responses);
    }

    /**
     * 添加-单个对象和分类列表关系
     * @param request
     * @return
     */
    @Override
    public Result addRelObjectCategoryList(ApiRelObjectCategoryListAddRequest request) {
        //先删后新增
        //根据业务对象业务ID删除关系
        iRelObjectCategoryService.delByObjectBizId(request.getObjectBizId());

        //新增
        if (!CollectionUtils.isEmpty(request.getCategoryBizIdList())) {
            //非空列表新增
            List<RelObjectCategory> relObjectCategoryList = request.getCategoryBizIdList()
                    .stream().map(categoryBizId -> {
                        RelObjectCategory relObjectCategory = new RelObjectCategory();
                        BeanUtils.copyProperties(request,relObjectCategory);
                        relObjectCategory.setCategoryBizId(categoryBizId);
                        return relObjectCategory;
                    }).collect(Collectors.toList());
            iRelObjectCategoryService.saveOrUpdateBatch(relObjectCategoryList);
        }
        return Result.success();
    }

    /**
     * 添加-单个分类和对象列表关系
     * @param request
     * @return
     */
    @Override
    public Result addRelCategoryObjectList(ApiRelCategoryObjectListAddRequest request) {
        //先删后新增
        //根据分类表唯一业务ID删除关系
        iRelObjectCategoryService.delByCategoryBizId(request.getCategoryBizId());

        //新增
        if (!CollectionUtils.isEmpty(request.getApiObjectDtoList())) {
            //非空列表新增
            List<RelObjectCategory> relObjectCategoryList = request.getApiObjectDtoList()
                    .stream().map(dto -> {
                        RelObjectCategory relObjectCategory = new RelObjectCategory();
                        BeanUtils.copyProperties(dto,relObjectCategory);
                        relObjectCategory.setCategoryBizId(request.getCategoryBizId());
                        return relObjectCategory;
                    }).collect(Collectors.toList());
            iRelObjectCategoryService.saveOrUpdateBatch(relObjectCategoryList);
        }
        return Result.success();
    }
}
