package com.yd.base.feign.client.relobjectfield;

import com.yd.base.feign.fallback.relobjectfield.ApiRelObjectFieldFeignFallbackFactory;
import com.yd.base.feign.request.relobjectfield.ApiRelObjectFieldListAddRequest;
import com.yd.base.feign.request.relobjectfield.ApiRelObjectFieldQueryRequest;
import com.yd.base.feign.response.relobjectfield.ApiRelObjectFieldQueryResponse;
import com.yd.common.result.Result;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;

import java.util.List;

/**
 * 基础数据服务-对象字段关系信息Feign客户端
 */
@FeignClient(name = "yd-base-api", fallbackFactory = ApiRelObjectFieldFeignFallbackFactory.class)
public interface ApiRelObjectFieldFeignClient {

    /**
     * 查询-对象字段关系列表
     * @param request
     * @return
     */
    @PostMapping("/query")
    Result<List<ApiRelObjectFieldQueryResponse>> query(@Validated @RequestBody ApiRelObjectFieldQueryRequest request);

    /**
     * 添加-单个对象和字段列表关系
     * @param request
     * @return
     */
    @PostMapping("/add/relObjectFieldList")
    Result addRelObjectFieldList(@Validated @RequestBody ApiRelObjectFieldListAddRequest request);
}
