package com.yd.base.api.controller;

import com.yd.base.api.service.ApiRelObjectCertificateService;
import com.yd.base.feign.client.relobjectcertificate.ApiRelObjectCertificateFeignClient;
import com.yd.base.feign.request.relobjectcertificate.ApiRelObjectCertificateListAddRequest;
import com.yd.base.feign.request.relobjectcertificate.ApiRelObjectCertificateListRequest;
import com.yd.base.feign.response.relobjectcertificate.ApiRelObjectCertificateListResponse;
import com.yd.common.result.Result;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.util.List;

/**
 * 对象证件关系信息
 *
 * @author zxm
 * @since 2026-02-02
 */
@RestController
@RequestMapping("/relObjectCertificate")
@Validated
public class ApiRelObjectCertificateController implements ApiRelObjectCertificateFeignClient {

    @Autowired
    private ApiRelObjectCertificateService apiRelObjectCertificateService;

    /**
     * 列表查询-对象和分类关系
     * @param request
     * @return
     */
    @Override
    public Result<List<ApiRelObjectCertificateListResponse>> list(ApiRelObjectCertificateListRequest request) {
        return apiRelObjectCertificateService.list(request);
    }

    /**
     * 添加-单个对象和分类列表关系
     * @param request
     * @return
     */
    @Override
    public Result addRelObjectCertificateList(ApiRelObjectCertificateListAddRequest request) {
        return apiRelObjectCertificateService.addRelObjectCertificateList(request);
    }

}
