package com.yd.base.api.service.impl;

import com.yd.base.api.service.ApiRelObjectCertificateService;
import com.yd.base.feign.request.relobjectcertificate.ApiRelObjectCertificateListAddRequest;
import com.yd.base.feign.request.relobjectcertificate.ApiRelObjectCertificateListRequest;
import com.yd.base.feign.response.relobjectcertificate.ApiRelObjectCertificateListResponse;
import com.yd.base.service.model.RelObjectCertificate;
import com.yd.base.service.service.IRelObjectCertificateService;
import com.yd.common.enums.CommonEnum;
import com.yd.common.result.Result;
import com.yd.common.utils.RandomStringGenerator;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

@Slf4j
@Service
public class ApiRelObjectCertificateServiceImpl implements ApiRelObjectCertificateService {

    @Autowired
    private IRelObjectCertificateService iRelObjectCertificateService;

    /**
     * 列表查询-对象和分类关系
     * @param request
     * @return
     */
    @Override
    public Result<List<ApiRelObjectCertificateListResponse>> list(ApiRelObjectCertificateListRequest request) {
        List<ApiRelObjectCertificateListResponse> responses = new ArrayList<>();
        List<RelObjectCertificate> list = iRelObjectCertificateService.list(request.getObjectBizId());
        if (!CollectionUtils.isEmpty(list)) {
            responses = list.stream().map(dto -> {
                ApiRelObjectCertificateListResponse response = new ApiRelObjectCertificateListResponse();
                BeanUtils.copyProperties(dto,response);
                return response;
            }).collect(Collectors.toList());
        }
        return Result.success(responses);
    }

    /**
     * 添加-单个对象和分类列表关系
     * @param request
     * @return
     */
    @Override
    public Result addRelObjectCertificateList(ApiRelObjectCertificateListAddRequest request) {
        //先删后新增
        //删除
        iRelObjectCertificateService.delByObjectBizId(request.getObjectBizId());

        if (!CollectionUtils.isEmpty(request.getApiCertificateDtoList())) {
            //新增
            List<RelObjectCertificate> addList = request.getApiCertificateDtoList()
                    .stream().map(dto -> {
                        RelObjectCertificate relObjectCertificate = new RelObjectCertificate();
                        BeanUtils.copyProperties(request,relObjectCertificate);
                        BeanUtils.copyProperties(dto,relObjectCertificate);
                        relObjectCertificate.setRelObjectCertificateBizId(RandomStringGenerator.generateBizId16(CommonEnum.UID_TYPE_REL_OBJECT_CERTIFICATE.getCode()));
                        return relObjectCertificate;
                    }).collect(Collectors.toList());
            iRelObjectCertificateService.saveOrUpdateBatch(addList);
        }
        return Result.success();
    }

}
