package com.yd.base.feign.dto;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.yd.common.utils.CustomLocalDateTimeDeserializer;
import lombok.Data;

import java.time.LocalDateTime;

@Data
public class ApiCertificateDto {

    /**
     * 证件类型
     */
    private String documentType;

    /**
     * 证件号码
     */
    private String idNumber;

    /**
     * 证件签发日期
     */
    @JsonDeserialize(using = CustomLocalDateTimeDeserializer.class)
    private LocalDateTime certificateIssueDate;

    /**
     * 证件有效期开始日期
     */
    @JsonDeserialize(using = CustomLocalDateTimeDeserializer.class)
    private LocalDateTime certificateStartDate;

    /**
     * 证件有效期截止日期，NULL表示长期有效
     */
    @JsonDeserialize(using = CustomLocalDateTimeDeserializer.class)
    private LocalDateTime certificateEndDate;

    /**
     * 是否长期有效：0-否，1-是
     */
    private Integer isPermanent;
}
