package com.yd.base.feign.response.relobjectcertificate;

import lombok.Data;

import java.time.LocalDateTime;

@Data
public class ApiRelObjectCertificateListResponse {

    /**
     * 主键ID
     */
    private Long id;

    /**
     * 对象证件关系表唯一业务ID
     */
    private String relObjectCertificateBizId;

    /**
     * 业务对象类型
     */
    private String objectType;

    /**
     * 业务对象所属表名
     */
    private String objectTableName;

    /**
     * 业务对象名
     */
    private String objectName;

    /**
     * 业务对象业务ID
     */
    private String objectBizId;

    /**
     * 证件类型
     */
    private String documentType;

    /**
     * 证件号码
     */
    private String idNumber;

    /**
     * 证件签发日期
     */
    private LocalDateTime certificateIssueDate;

    /**
     * 证件有效期开始日期
     */
    private LocalDateTime certificateStartDate;

    /**
     * 证件有效期截止日期，NULL表示长期有效
     */
    private LocalDateTime certificateEndDate;

    /**
     * 是否长期有效：0-否，1-是
     */
    private Integer isPermanent;
}
