package com.yd.base.service.model;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;
import lombok.Getter;
import lombok.Setter;

/**
 * <p>
 * 汇率表
 * </p>
 *
 * @author zxm
 * @since 2025-12-29
 */
@Getter
@Setter
@TableName("exchange_rate")
public class ExchangeRate implements Serializable {

    private static final long serialVersionUID = 1L;

    /**
     * 主键ID
     */
    @TableId(value = "id", type = IdType.AUTO)
    private Long id;

    /**
     * 基础币种代码(ISO 4217标准)
     */
    @TableField("base_currency")
    private String baseCurrency;

    /**
     * 基础币种名称
     */
    @TableField("base_currency_name")
    private String baseCurrencyName;

    /**
     * 目标币种代码(ISO 4217标准)
     */
    @TableField("target_currency")
    private String targetCurrency;

    /**
     * 目标币种名称
     */
    @TableField("target_currency_name")
    private String targetCurrencyName;

    /**
     * 汇率(1单位基础币种可兑换的目标币种数量)
     */
    @TableField("exchange_rate")
    private BigDecimal exchangeRate;

    /**
     * 生效日期
     */
    @TableField("effective_date")
    private LocalDate effectiveDate;

    /**
     * 失效日期(NULL表示永久有效)
     */
    @TableField("expiration_date")
    private LocalDate expirationDate;

    /**
     * 汇率类型: SPOT-即期, FORWARD-远期, HISTORICAL-历史
     */
    @TableField("rate_type")
    private String rateType;

    /**
     * 数据来源: SYSTEM-系统设置, API-外部接口, MANUAL-手动录入
     */
    @TableField("source")
    private String source;

    /**
     * 是否有效: 0-无效, 1-有效
     */
    @TableField("is_active")
    private Integer isActive;

    /**
     * 通用备注
     */
    @TableField("remark")
    private String remark;

    /**
     * 删除标识：0-正常，1-删除
     */
    @TableField("is_deleted")
    private Integer isDeleted;

    /**
     * 创建人ID
     */
    @TableField("creator_id")
    private String creatorId;

    /**
     * 更新人ID
     */
    @TableField("updater_id")
    private String updaterId;

    /**
     * 创建时间
     */
    @TableField("create_time")
    private LocalDateTime createTime;

    /**
     * 更新时间
     */
    @TableField("update_time")
    private LocalDateTime updateTime;
}
