package com.yd.base.api.controller;

import com.yd.base.api.service.ApiRelObjectFieldService;
import com.yd.base.feign.client.relobjectfield.ApiRelObjectFieldFeignClient;
import com.yd.base.feign.request.relobjectfield.ApiRelObjectFieldListAddRequest;
import com.yd.base.feign.request.relobjectfield.ApiRelObjectFieldQueryRequest;
import com.yd.base.feign.response.relobjectfield.ApiRelObjectFieldQueryResponse;
import com.yd.common.result.Result;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.util.List;

/**
 * 对象字段关系信息
 *
 * @author zxm
 * @since 2025-11-20
 */
@RestController
@RequestMapping("/relObjectField")
@Validated
public class ApiRelObjectFieldController implements ApiRelObjectFieldFeignClient {

    @Autowired
    private ApiRelObjectFieldService apiRelObjectFieldService;

    /**
     * 查询-对象字段关系列表
     * @param request
     * @return
     */
    @Override
    public Result<List<ApiRelObjectFieldQueryResponse>> query(ApiRelObjectFieldQueryRequest request) {
        return apiRelObjectFieldService.query(request);
    }

    /**
     * 添加-单个对象和字段列表关系
     * @param request
     * @return
     */
    @Override
    public Result addRelObjectFieldList(ApiRelObjectFieldListAddRequest request) {
        return apiRelObjectFieldService.addRelObjectFieldList(request);
    }
}
