package com.yd.base.api.controller;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.yd.base.api.service.SpeciesTypeService;
import com.yd.base.feign.client.speciestype.ApiSpeciesTypeFeignClient;
import com.yd.base.feign.dto.ApiSpeciesCustomizeDto;
import com.yd.base.feign.request.speciestype.ApiSpeciesCustomizeSaveRequest;
import com.yd.base.feign.request.speciestype.ApiSpeciesTypeAddRequest;
import com.yd.base.feign.request.speciestype.ApiSpeciesTypeEditRequest;
import com.yd.base.feign.request.speciestype.ApiSpeciesTypePageRequest;
import com.yd.base.feign.response.speciestype.ApiSpeciesTypeDetailResponse;
import com.yd.base.feign.response.speciestype.ApiSpeciesTypePageResponse;
import com.yd.common.result.Result;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.util.List;

/**
 * 规格类型信息
 *
 * @author zxm
 * @since 2025-11-21
 */
@RestController
@RequestMapping("/speciesType")
@Validated
public class ApiSpeciesTypeController implements ApiSpeciesTypeFeignClient {

    @Autowired
    private SpeciesTypeService speciesTypeService;

    /**
     * 分页列表查询-规格类型
     * @param request
     * @return
     */
    @Override
    public Result<IPage<ApiSpeciesTypePageResponse>> page(ApiSpeciesTypePageRequest request) {
        return speciesTypeService.page(request);
    }

    /**
     * 添加-规格类型
     * @param request
     * @return
     */
    @Override
    public Result add(ApiSpeciesTypeAddRequest request) {
        return speciesTypeService.add(request);
    }

    /**
     * 编辑-规格类型
     * @param request
     * @return
     */
    @Override
    public Result edit(ApiSpeciesTypeEditRequest request) {
        return speciesTypeService.edit(request);
    }

    /**
     * 详情-规格类型
     * @param speciesTypeBizId 规格类型表唯一业务ID
     * @return
     */
    @Override
    public Result<ApiSpeciesTypeDetailResponse> detail(String speciesTypeBizId) {
        return speciesTypeService.detail(speciesTypeBizId);
    }

    /**
     * 删除-规格类型 TODO
     * @param speciesTypeBizId 规格类型表唯一业务ID
     * @return
     */
    @Override
    public Result del(String speciesTypeBizId) {
        return speciesTypeService.del(speciesTypeBizId);
    }

    /**
     * 保存-规格自定义数据
     * @param request
     * @return
     */
    @Override
    public Result<List<ApiSpeciesCustomizeDto>> saveCustomize(ApiSpeciesCustomizeSaveRequest request) {
        return speciesTypeService.saveCustomize(request);
    }

}
