package com.yd.base.feign.client.bank;

import com.yd.base.feign.fallback.bank.ApiBankFeignFallbackFactory;
import com.yd.base.feign.request.bank.ApiBankAddRequest;
import com.yd.base.feign.request.bank.ApiBankEditRequest;
import com.yd.base.feign.request.bank.ApiBankListRequest;
import com.yd.base.feign.request.bank.ApiBankPageRequest;
import com.yd.base.feign.response.bank.ApiBankDetailResponse;
import com.yd.common.result.Result;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import java.util.List;

/**
 * 基础数据服务-银行基础信息Feign客户端
 */
@FeignClient(name = "yd-base-api",path = "/base/api/bank",fallbackFactory = ApiBankFeignFallbackFactory.class)
public interface ApiBankFeignClient {

    /**
     * 分页列表查询-银行信息
     * @param request
     * @return
     */
    @PostMapping("/page")
    Result page(@RequestBody ApiBankPageRequest request);

    /**
     * 列表查询-银行信息
     * @param request
     * @return
     */
    @PostMapping("/list")
    Result<List<ApiBankDetailResponse>> list(@RequestBody ApiBankListRequest request);

    /**
     * 添加-银行信息
     * @param request
     * @return
     */
    @PostMapping("/add")
    Result add(@Validated @RequestBody ApiBankAddRequest request);

    /**
     * 编辑-银行信息
     * @param request
     * @return
     */
    @PutMapping("/edit")
    Result edit(@Validated @RequestBody ApiBankEditRequest request);

    /**
     * 详情-银行信息
     * @param bankBizId 银行信息表唯一业务ID
     * @return
     */
    @GetMapping("/detail")
    Result<ApiBankDetailResponse> detail(@NotBlank(message = "银行信息表唯一业务ID能为空") @RequestParam(value = "bankBizId") String bankBizId);

    /**
     * 删除-银行信息
     * @param bankBizId 银行信息表唯一业务ID
     * @return
     */
    @DeleteMapping("/del")
    Result del(@NotBlank(message = "银行信息表唯一业务ID能为空") @RequestParam(value = "bankBizId") String bankBizId);

    /**
     * 编辑银行信息状态
     * @param bankBizId 银行信息唯一标识(业务ID)
     * @param status 状态：1-有效，0-无效。
     * @return
     */
    @PatchMapping("/edit/status")
    Result editStatus(@NotBlank(message = "银行信息表唯一业务ID能为空") @RequestParam(value = "bankBizId") String bankBizId,
                      @NotNull(message = "状态不能为空") @RequestParam(value = "status") Integer status);
}
