package com.yd.base.feign.client.exchangerate;

import com.yd.base.feign.fallback.exchangerate.ApiExchangeRateFeignFallbackFactory;
import com.yd.base.feign.request.exchangerate.ApiExchangeRateConvertRequest;
import com.yd.base.feign.response.exchangerate.ApiExchangeRateConvertResponse;
import com.yd.common.result.Result;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;
import java.math.BigDecimal;
import java.util.List;

/**
 * 基础数据服务-汇率信息Feign客户端
 */
@FeignClient(name = "yd-base-api",path = "/base/api/exchangeRate",fallbackFactory = ApiExchangeRateFeignFallbackFactory.class)
public interface ApiExchangeRateFeignClient {

    /**
     * 货币转换
     * @param request
     * @return
     */
    @PostMapping("/convert")
    Result<ApiExchangeRateConvertResponse> convert(@RequestBody ApiExchangeRateConvertRequest request);

    /**
     * 获取汇率
     * @param baseCurrency 基础币种
     * @param targetCurrency 目标币种
     * @param date
     * @return
     */
    @GetMapping("/rate")
    Result<BigDecimal> getExchangeRate(
            @RequestParam("baseCurrency") String baseCurrency,
            @RequestParam("targetCurrency") String targetCurrency,
            @RequestParam(value = "date", required = false) String date
    );

    /**
     * 批量转换
     * @param requests
     * @return
     */
    @PostMapping("/batch/convert")
    Result<List<ApiExchangeRateConvertResponse>> batchConvert(@RequestBody List<ApiExchangeRateConvertRequest> requests);

    /**
     * 验证币种是否支持
     * @param currency
     * @return
     */
    @GetMapping("/currency/supported")
    Result<Boolean> isCurrencySupportedResult(@RequestParam("currency") String currency);

    /**
     * 获取支持的币种列表
     * @return
     */
    @GetMapping("/currencies")
    Result<List<String>> getSupportedCurrencies();
}
