package com.yd.base.feign.request.species;

import lombok.Data;
import javax.validation.constraints.NotBlank;

@Data
public class ApiSpeciesEditRequest {

    /**
     * 规格表唯一业务ID
     */
    @NotBlank(message = "规格表唯一业务ID不能为空")
    private String speciesBizId;

    /**
     * 规格类型表唯一业务ID
     */
    @NotBlank(message = "规格类型表唯一业务ID不能为空")
    private String speciesTypeBizId;

    /**
     * 规格值
     */
    @NotBlank(message = "规格值不能为空")
    private String value;

    /**
     * 排序
     */
    private Integer sort;

    /**
     * 通用备注
     */
    private String remark;
}
