package com.yd.base.feign.response.field;

import lombok.Data;
import java.time.LocalDateTime;

@Data
public class ApiFieldDetailResponse {

    /**
     * 主键ID
     */
    private Long id;

    /**
     * 字段表唯一业务ID
     */
    private String fieldBizId;

    /**
     * 字段编码（唯一标识）
     */
    private String fieldCode;

    /**
     * 字段中文名称
     */
    private String fieldCnName;

    /**
     * 字段英文名称
     */
    private String fieldEnName;

    /**
     * 字段数据类型（varchar/int/decimal/date/datetime/text等）
     */
    private String fieldType;

    /**
     * 字段长度
     */
    private Integer fieldLength;

    /**
     * 字段精度（针对decimal类型）
     */
    private Integer fieldPrecision;

    /**
     * 是否必填：0-否，1-是
     */
    private Integer isRequired;

    /**
     * 默认值
     */
    private String defaultValue;

    /**
     * 字段排序
     */
    private Integer fieldOrder;

    /**
     * 状态：0-禁用，1-启用
     */
    private Integer status;

    /**
     * 字段说明备注
     */
    private String remark;

    /**
     * 删除标识：0-正常，1-删除
     */
    private Integer isDeleted;

    /**
     * 创建人ID
     */
    private String creatorId;

    /**
     * 更新人ID
     */
    private String updaterId;

    /**
     * 创建时间
     */
    private LocalDateTime createTime;

    /**
     * 更新时间
     */
    private LocalDateTime updateTime;

    /**
     * 文本框类型
     */
    private String textBoxType;
}
