package com.yd.base.feign.client.relobjectspecies;

import com.yd.base.feign.fallback.relobjectspecies.ApiRelObjectSpeciesFeignFallbackFactory;
import com.yd.base.feign.request.relobjectspecies.ApiRelObjectSpeciesListAddRequest;
import com.yd.base.feign.request.relobjectspecies.ApiRelObjectSpeciesQueryRequest;
import com.yd.base.feign.response.relobjectspecies.ApiRelObjectSpeciesQueryResponse;
import com.yd.common.result.Result;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;

import java.util.List;

/**
 * 基础数据服务-对象规格关系信息Feign客户端
 */
@FeignClient(name = "yd-base-api", fallbackFactory = ApiRelObjectSpeciesFeignFallbackFactory.class)
public interface ApiRelObjectSpeciesFeignClient {

    /**
     * 查询-对象规格关系列表
     * @param request
     * @return
     */
    @PostMapping("/query")
    Result<List<ApiRelObjectSpeciesQueryResponse>> query(@Validated @RequestBody ApiRelObjectSpeciesQueryRequest request);

    /**
     * 添加-单个对象和规格列表关系
     * @param request
     * @return
     */
    @PostMapping("/add/relObjectSpeciesList")
    Result addRelObjectSpeciesList(@Validated @RequestBody ApiRelObjectSpeciesListAddRequest request);
}
