package com.yd.base.feign.client.relfieldvalue;

import com.yd.base.feign.fallback.relfieldvalue.ApiRelFieldValueFeignFallbackFactory;
import com.yd.base.feign.request.relfieldvalue.ApiRelFieldValuePageRequest;
import com.yd.common.result.Result;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;

/**
 * 基础数据服务-字段和字段值关系信息Feign客户端
 */
@FeignClient(name = "yd-base-api", fallbackFactory = ApiRelFieldValueFeignFallbackFactory.class)
public interface ApiRelFieldValueFeignClient {

    /**
     * 分页列表查询-字段和字段值关系信息
     * @param request
     * @return
     */
    @PostMapping("/page")
    Result page(@RequestBody ApiRelFieldValuePageRequest request);
}
