package com.yd.base.feign.client.speciestype;

import com.yd.base.feign.fallback.speciestype.ApiSpeciesTypeFeignFallbackFactory;
import com.yd.base.feign.request.speciestype.ApiSpeciesTypeAddRequest;
import com.yd.base.feign.request.speciestype.ApiSpeciesTypeEditRequest;
import com.yd.base.feign.request.speciestype.ApiSpeciesTypePageRequest;
import com.yd.base.feign.response.speciestype.ApiSpeciesTypeDetailResponse;
import com.yd.common.result.Result;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;
import javax.validation.constraints.NotBlank;

/**
 * 基础数据服务-规格类型类型信息Feign客户端
 */
@FeignClient(name = "yd-base-api", fallbackFactory = ApiSpeciesTypeFeignFallbackFactory.class)
public interface ApiSpeciesTypeFeignClient {

    /**
     * 分页列表查询-规格类型
     * @param request
     * @return
     */
    @PostMapping("/page")
    Result page(@RequestBody ApiSpeciesTypePageRequest request);

    /**
     * 添加-规格类型
     * @param request
     * @return
     */
    @PostMapping("/add")
    Result add(@Validated @RequestBody ApiSpeciesTypeAddRequest request);

    /**
     * 编辑-规格类型
     * @param request
     * @return
     */
    @PutMapping("/edit")
    Result edit(@Validated @RequestBody ApiSpeciesTypeEditRequest request);

    /**
     * 详情-规格类型
     * @param speciesTypeBizId 规格类型表唯一业务ID
     * @return
     */
    @GetMapping("/detail")
    Result<ApiSpeciesTypeDetailResponse> detail(@NotBlank(message = "规格类型表唯一业务ID能为空") @RequestParam(value = "speciesTypeBizId") String speciesTypeBizId);

    /**
     * 删除-规格类型
     * @param speciesTypeBizId 规格类型表唯一业务ID
     * @return
     */
    @DeleteMapping("/del")
    Result del(@NotBlank(message = "规格类型表唯一业务ID能为空") @RequestParam(value = "speciesTypeBizId") String speciesTypeBizId);
}
