package com.yd.base.feign.fallback.relobjectfield;

import com.yd.base.feign.client.relobjectfield.ApiRelObjectFieldFeignClient;
import com.yd.base.feign.request.relobjectfield.ApiRelObjectFieldListAddRequest;
import com.yd.base.feign.request.relobjectfield.ApiRelObjectFieldQueryRequest;
import com.yd.base.feign.response.relobjectfield.ApiRelObjectFieldQueryResponse;
import com.yd.common.result.Result;
import lombok.extern.slf4j.Slf4j;
import org.springframework.cloud.openfeign.FallbackFactory;
import org.springframework.stereotype.Component;

import java.util.List;

/**
 * 基础数据服务-对象字段关系信息Feign降级处理
 */
@Slf4j
@Component
public class ApiRelObjectFieldFeignFallbackFactory implements FallbackFactory<ApiRelObjectFieldFeignClient> {

    @Override
    public ApiRelObjectFieldFeignClient create(Throwable cause) {
        return new ApiRelObjectFieldFeignClient() {
            @Override
            public Result<List<ApiRelObjectFieldQueryResponse>> query(ApiRelObjectFieldQueryRequest request) {
                return null;
            }

            @Override
            public Result addRelObjectFieldList(ApiRelObjectFieldListAddRequest request) {
                return null;
            }
        };
    }
}
