/*
 * Decompiled with CFR 0.152.
 */
package com.yd.base.api.service.impl;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yd.base.api.service.ApiCategoryService;
import com.yd.base.feign.request.category.ApiCategoryAddRequest;
import com.yd.base.feign.request.category.ApiCategoryEditRequest;
import com.yd.base.feign.request.category.ApiCategoryPageRequest;
import com.yd.base.feign.request.category.ApiCategoryTreeListRequest;
import com.yd.base.feign.response.category.ApiCategoryDetailResponse;
import com.yd.base.feign.response.category.ApiCategoryPageResponse;
import com.yd.base.feign.response.category.ApiCategoryTreeListResponse;
import com.yd.base.service.dto.CategoryDto;
import com.yd.base.service.model.Category;
import com.yd.base.service.service.ICategoryService;
import com.yd.common.enums.CommonEnum;
import com.yd.common.exception.BusinessException;
import com.yd.common.result.Result;
import com.yd.common.utils.CodeGenerator;
import com.yd.common.utils.RandomStringGenerator;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class ApiCategoryServiceImpl
implements ApiCategoryService {
    private static final Logger log = LoggerFactory.getLogger(ApiCategoryServiceImpl.class);
    @Autowired
    private ICategoryService iCategoryService;

    @Override
    public Result<IPage<ApiCategoryPageResponse>> page(ApiCategoryPageRequest request) {
        Page page = new Page((long)request.getPageNo().intValue(), (long)request.getPageSize().intValue());
        IPage iPage = this.iCategoryService.page(page, request);
        return Result.success((Object)iPage);
    }

    @Override
    public Result<List<ApiCategoryTreeListResponse>> treeList(ApiCategoryTreeListRequest request) {
        return null;
    }

    @Override
    public Result add(ApiCategoryAddRequest request) {
        List categoryList = this.iCategoryService.queryList(CategoryDto.builder().name(request.getName()).build());
        if (!CollectionUtils.isEmpty((Collection)categoryList)) {
            throw new BusinessException("\u5206\u7c7b\u540d\u79f0\u5df2\u5b58\u5728");
        }
        Category category = new Category();
        category.setCategoryBizId(RandomStringGenerator.generateBizId16((String)CommonEnum.UID_TYPE_CATEGORY.getCode()));
        category.setCode(CodeGenerator.generate10Code((String)"CATEGORY"));
        category.setPid(request.getPid());
        category.setName(request.getName());
        category.setLevel(this.calculateLevel(request.getPid()));
        category.setPath(this.calculatePath(request.getPid(), category.getCategoryBizId()));
        category.setRemark(request.getRemark());
        category.setType(request.getType());
        this.iCategoryService.saveOrUpdate((Object)category);
        return Result.success();
    }

    @Override
    public Result edit(ApiCategoryEditRequest request) {
        Result<Category> result = this.checkCategoryIsExist(request.getCategoryBizId());
        Category category = (Category)result.getData();
        List categoryList = this.iCategoryService.queryList(CategoryDto.builder().name(request.getName()).categoryBizId(request.getCategoryBizId()).isExcludeMy(Boolean.valueOf(true)).build());
        if (!CollectionUtils.isEmpty((Collection)categoryList)) {
            throw new BusinessException("\u5206\u7c7b\u540d\u79f0\u5df2\u5b58\u5728");
        }
        category.setPid(request.getPid());
        category.setName(request.getName());
        category.setLevel(this.calculateLevel(request.getPid()));
        category.setPath(this.calculatePath(request.getPid(), category.getCategoryBizId()));
        category.setRemark(request.getRemark());
        category.setType(request.getType());
        this.iCategoryService.saveOrUpdate((Object)category);
        return Result.success();
    }

    @Override
    public Result<ApiCategoryDetailResponse> detail(String categoryBizId) {
        Result<Category> result = this.checkCategoryIsExist(categoryBizId);
        Category category = (Category)result.getData();
        ApiCategoryDetailResponse response = new ApiCategoryDetailResponse();
        BeanUtils.copyProperties((Object)category, (Object)response);
        return Result.success((Object)response);
    }

    @Override
    public Result del(String categoryBizId) {
        return null;
    }

    public Integer calculateLevel(String pid) {
        if (StringUtils.isBlank((CharSequence)pid) || "0".equals(pid)) {
            return 1;
        }
        Category category = this.iCategoryService.queryOne(CategoryDto.builder().pid(pid).build());
        return category.getLevel() + 1;
    }

    public String calculatePath(String pid, String categoryBizId) {
        if (StringUtils.isBlank((CharSequence)pid) || "0".equals(pid)) {
            return categoryBizId;
        }
        Category category = this.iCategoryService.queryOne(CategoryDto.builder().pid(pid).build());
        return category.getPath() + "&" + categoryBizId;
    }

    public Result<Category> checkCategoryIsExist(String categoryBizId) {
        Category category = this.iCategoryService.queryOne(CategoryDto.builder().categoryBizId(categoryBizId).build());
        if (Objects.isNull(category)) {
            throw new BusinessException("\u5206\u7c7b\u6570\u636e\u4e0d\u5b58\u5728");
        }
        return Result.success((Object)category);
    }
}

