package com.yd.base.feign.client.field;

import com.yd.base.feign.fallback.field.ApiFieldFeignFallbackFactory;
import com.yd.base.feign.request.field.ApiFieldAddRequest;
import com.yd.base.feign.request.field.ApiFieldEditRequest;
import com.yd.base.feign.request.field.ApiFieldListRequest;
import com.yd.base.feign.request.field.ApiFieldPageRequest;
import com.yd.base.feign.response.field.ApiFieldDetailResponse;
import com.yd.common.result.Result;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;
import javax.validation.constraints.NotBlank;
import java.util.List;

/**
 * 基础数据服务-字段信息Feign客户端
 */
@FeignClient(name = "yd-base-api",path = "/base/api/field",fallbackFactory = ApiFieldFeignFallbackFactory.class)
public interface ApiFieldFeignClient {

    /**
     * 分页列表查询-字段
     * @param request
     * @return
     */
    @PostMapping("/page")
    Result page(@RequestBody ApiFieldPageRequest request);

    /**
     * 列表查询-字段
     * @param request
     * @return
     */
    @PostMapping("/list")
    Result<List<ApiFieldDetailResponse>> list(@RequestBody ApiFieldListRequest request);

    /**
     * 添加-字段
     * @param request
     * @return
     */
    @PostMapping("/add")
    Result add(@Validated @RequestBody ApiFieldAddRequest request);

    /**
     * 编辑-字段
     * @param request
     * @return
     */
    @PutMapping("/edit")
    Result edit(@Validated @RequestBody ApiFieldEditRequest request);

    /**
     * 详情-字段
     * @param fieldBizId 字段表唯一业务ID
     * @return
     */
    @GetMapping("/detail")
    Result<ApiFieldDetailResponse> detail(@NotBlank(message = "字段表唯一业务ID能为空") @RequestParam(value = "fieldBizId") String fieldBizId);

    /**
     * 删除-字段
     * @param fieldBizId 字段表唯一业务ID
     * @return
     */
    @DeleteMapping("/del")
    Result del(@NotBlank(message = "字段表唯一业务ID能为空") @RequestParam(value = "fieldBizId") String fieldBizId);
}
