package com.yd.base.api.service.impl;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yd.base.api.service.ApiBankService;
import com.yd.base.feign.request.bank.ApiBankAddRequest;
import com.yd.base.feign.request.bank.ApiBankEditRequest;
import com.yd.base.feign.request.bank.ApiBankListRequest;
import com.yd.base.feign.request.bank.ApiBankPageRequest;
import com.yd.base.feign.response.bank.ApiBankDetailResponse;
import com.yd.base.feign.response.bank.ApiBankPageResponse;
import com.yd.base.service.service.IBankService;
import com.yd.common.result.Result;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import java.util.List;

@Slf4j
@Service
public class ApiBankServiceImpl implements ApiBankService {

    @Autowired
    private IBankService iBankService;

    /**
     * 分页列表查询-银行信息
     * @param request
     * @return
     */
    @Override
    public Result<IPage<ApiBankPageResponse>> page(ApiBankPageRequest request) {
        Page<ApiBankPageResponse> page = new Page<>(request.getPageNo(), request.getPageSize());
        IPage<ApiBankPageResponse> iPage = iBankService.page(page, request);
        return Result.success(iPage);
    }

    /**
     * 列表查询-银行信息
     * @param request
     * @return
     */
    @Override
    public Result<List<ApiBankDetailResponse>> list(ApiBankListRequest request) {
        return null;
    }

    /**
     * 添加-银行信息
     * @param request
     * @return
     */
    @Override
    public Result add(ApiBankAddRequest request) {
        return null;
    }

    /**
     * 编辑-银行信息
     * @param request
     * @return
     */
    @Override
    public Result edit(ApiBankEditRequest request) {
        return null;
    }

    /**
     * 详情-银行信息
     * @param bankBizId 银行信息表唯一业务ID
     * @return
     */
    @Override
    public Result<ApiBankDetailResponse> detail(String bankBizId) {
        return null;
    }

    /**
     * 删除-银行信息
     * @param bankBizId 银行信息表唯一业务ID
     * @return
     */
    @Override
    public Result del(String bankBizId) {
        return null;
    }

    /**
     * 编辑银行信息状态
     * @param bankBizId 银行信息唯一标识(业务ID)
     * @param status 状态：1-有效，0-无效。
     * @return
     */
    @Override
    public Result editStatus(String bankBizId, Integer status) {
        return null;
    }

}
