package com.yd.base.api.controller;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.yd.common.result.Result;
import com.yd.base.api.service.ApiCategoryService;
import com.yd.base.feign.client.category.ApiCategoryFeignClient;
import com.yd.base.feign.request.category.ApiCategoryAddRequest;
import com.yd.base.feign.request.category.ApiCategoryEditRequest;
import com.yd.base.feign.request.category.ApiCategoryPageRequest;
import com.yd.base.feign.request.category.ApiCategoryTreeListRequest;
import com.yd.base.feign.response.category.ApiCategoryDetailResponse;
import com.yd.base.feign.response.category.ApiCategoryPageResponse;
import com.yd.base.feign.response.category.ApiCategoryTreeListResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.util.List;

/**
 * 分类信息
 *
 * @author zxm
 * @since 2025-11-20
 */
@RestController
@RequestMapping("/category")
@Validated
public class ApiCategoryController implements ApiCategoryFeignClient {

    @Autowired
    private ApiCategoryService apiCategoryService;

    /**
     * 分页列表查询-分类
     * @param request
     * @return
     */
    @Override
    public Result<IPage<ApiCategoryPageResponse>> page(ApiCategoryPageRequest request) {
        return apiCategoryService.page(request);
    }

    /**
     * 树形列表查询-分类
     * @param request
     * @return
     */
    @Override
    public Result<List<ApiCategoryTreeListResponse>> treeList(ApiCategoryTreeListRequest request) {
        return apiCategoryService.treeList(request);
    }

    /**
     * 添加分类
     * @param request
     * @return
     */
    @Override
    public Result add(ApiCategoryAddRequest request) {
        return apiCategoryService.add(request);
    }

    /**
     * 编辑分类
     * @param request
     * @return
     */
    @Override
    public Result edit(ApiCategoryEditRequest request) {
        return apiCategoryService.edit(request);
    }

    /**
     * 详情-分类
     * @param categoryBizId 分类表唯一业务ID
     * @return
     */
    @Override
    public Result<ApiCategoryDetailResponse> detail(String categoryBizId) {
        return apiCategoryService.detail(categoryBizId);
    }

    /**
     * 删除-分类 TODO
     * @param categoryBizId 分类表唯一业务ID
     * @return
     */
    @Override
    public Result del(String categoryBizId) {
        return apiCategoryService.del(categoryBizId);
    }

}
