package com.yd.base.api.service.impl;

import com.yd.base.api.service.ApiRelObjectCategoryService;
import com.yd.base.feign.request.relobjectcategory.ApiRelCategoryObjectListAddRequest;
import com.yd.base.feign.request.relobjectcategory.ApiRelObjectCategoryListAddRequest;
import com.yd.base.feign.request.relobjectcategory.ApiRelObjectCategoryQueryRequest;
import com.yd.base.feign.request.relobjectcategory.ApiRelObjectCategoryQuerySelectedRequest;
import com.yd.base.feign.response.relobjectcategory.ApiCategorySelectedResponse;
import com.yd.base.feign.response.relobjectcategory.ApiRelObjectCategoryQueryResponse;
import com.yd.base.feign.response.relobjectcategory.ApiRelObjectCategoryQuerySelectedResponse;
import com.yd.base.service.dto.CategoryDto;
import com.yd.base.service.dto.RelObjectCategoryDto;
import com.yd.base.service.model.Category;
import com.yd.base.service.model.RelObjectCategory;
import com.yd.base.service.service.ICategoryService;
import com.yd.base.service.service.IRelObjectCategoryService;
import com.yd.common.result.Result;
import com.yd.question.feign.dto.ApiRelQuestionsGroupDto;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;

@Slf4j
@Service
public class ApiRelObjectCategoryServiceImpl implements ApiRelObjectCategoryService {

    @Autowired
    private IRelObjectCategoryService iRelObjectCategoryService;

    @Autowired
    private ICategoryService iCategoryService;

    /**
     * 查询-对象分类关系列表
     * @param request
     * @return
     */
    @Override
    public Result<List<ApiRelObjectCategoryQueryResponse>> query(ApiRelObjectCategoryQueryRequest request) {
        List<ApiRelObjectCategoryQueryResponse> responses = iRelObjectCategoryService.query(request);
        return Result.success(responses);
    }

    /**
     * 查询-选中的分类列表
     * @param request
     * @return
     */
    @Override
    public Result<List<ApiRelObjectCategoryQuerySelectedResponse>> querySelected(ApiRelObjectCategoryQuerySelectedRequest request) {
        List<ApiRelObjectCategoryQuerySelectedResponse> responses = new ArrayList<>();
        //根据对象业务ID查询选中的分类列表
        List<RelObjectCategory> relObjectCategoryList = iRelObjectCategoryService.queryList(RelObjectCategoryDto.builder()
                .objectBizId(request.getObjectBizId()).build());
        List<String> selectedCategoryBizIdList = new ArrayList<>();
        if (!CollectionUtils.isEmpty(relObjectCategoryList)) {
            selectedCategoryBizIdList = relObjectCategoryList.stream()
                    .map(RelObjectCategory::getCategoryBizId)
                    .collect(Collectors.toList());
        }
        List<String> compareSelectedCategoryBizIdList = selectedCategoryBizIdList;
        List<Category> categoryList = iCategoryService.queryList(CategoryDto.builder().type(request.getType()).pid("0").build());
        ApiRelObjectCategoryQuerySelectedResponse selectedResponse1 = new ApiRelObjectCategoryQuerySelectedResponse();
        selectedResponse1.setLevel(1);
        if (!CollectionUtils.isEmpty(categoryList)) {
            List<ApiCategorySelectedResponse> selectedResponseList = categoryList.stream().map(dto -> {
                ApiCategorySelectedResponse response = new ApiCategorySelectedResponse();
                BeanUtils.copyProperties(dto,response);
                List<String> filterList = compareSelectedCategoryBizIdList.stream().filter(bizId -> bizId.equals(dto.getCategoryBizId())).collect(Collectors.toList());
                if (!CollectionUtils.isEmpty(filterList)) {
                    response.setIsSelected(true);
                }
                return response;
            }).collect(Collectors.toList());
            selectedResponse1.setSelectedResponseList(selectedResponseList);
            responses.add(selectedResponse1);
        }
        if (!CollectionUtils.isEmpty(compareSelectedCategoryBizIdList)) {
            for (String categoryBizId : selectedCategoryBizIdList) {
                List<Category> childList = iCategoryService.queryList(CategoryDto.builder().pid(categoryBizId).build());
                if (!CollectionUtils.isEmpty(childList)) {
                    ApiRelObjectCategoryQuerySelectedResponse selectedResponse = new ApiRelObjectCategoryQuerySelectedResponse();
                    List<ApiCategorySelectedResponse> selectedResponseList = childList.stream().map(dto -> {
                        selectedResponse.setLevel(dto.getLevel());
                        ApiCategorySelectedResponse response = new ApiCategorySelectedResponse();
                        BeanUtils.copyProperties(dto,response);
                        List<String> filterList = compareSelectedCategoryBizIdList.stream().filter(bizId -> bizId.equals(dto.getCategoryBizId())).collect(Collectors.toList());
                        if (!CollectionUtils.isEmpty(filterList)) {
                            response.setIsSelected(true);
                        }
                        return response;
                    }).collect(Collectors.toList());
                    selectedResponse.setSelectedResponseList(selectedResponseList);
                    responses.add(selectedResponse);
                }
            }
        }
        responses = responses.stream()
                    .sorted(Comparator.comparing(ApiRelObjectCategoryQuerySelectedResponse::getLevel))
                    .collect(Collectors.toList());
        return Result.success(responses);
    }

    /**
     * 添加-单个对象和分类列表关系
     * @param request
     * @return
     */
    @Override
    public Result addRelObjectCategoryList(ApiRelObjectCategoryListAddRequest request) {
        //先删后新增
        //根据业务对象业务ID删除关系
        iRelObjectCategoryService.delByObjectBizId(request.getObjectBizId());

        //新增
        if (!CollectionUtils.isEmpty(request.getCategoryBizIdList())) {
            //非空列表新增
            List<RelObjectCategory> relObjectCategoryList = request.getCategoryBizIdList()
                    .stream().map(categoryBizId -> {
                        RelObjectCategory relObjectCategory = new RelObjectCategory();
                        BeanUtils.copyProperties(request,relObjectCategory);
                        relObjectCategory.setCategoryBizId(categoryBizId);
                        return relObjectCategory;
                    }).collect(Collectors.toList());
            iRelObjectCategoryService.saveOrUpdateBatch(relObjectCategoryList);
        }
        return Result.success();
    }

    /**
     * 添加-单个分类和对象列表关系
     * @param request
     * @return
     */
    @Override
    public Result addRelCategoryObjectList(ApiRelCategoryObjectListAddRequest request) {
        //先删后新增
        //根据分类表唯一业务ID删除关系
        iRelObjectCategoryService.delByCategoryBizId(request.getCategoryBizId());

        //新增
        if (!CollectionUtils.isEmpty(request.getApiObjectDtoList())) {
            //非空列表新增
            List<RelObjectCategory> relObjectCategoryList = request.getApiObjectDtoList()
                    .stream().map(dto -> {
                        RelObjectCategory relObjectCategory = new RelObjectCategory();
                        BeanUtils.copyProperties(dto,relObjectCategory);
                        relObjectCategory.setCategoryBizId(request.getCategoryBizId());
                        return relObjectCategory;
                    }).collect(Collectors.toList());
            iRelObjectCategoryService.saveOrUpdateBatch(relObjectCategoryList);
        }
        return Result.success();
    }

}
