package com.yd.base.feign.request.exchangerate;

import lombok.Data;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import java.math.BigDecimal;
import java.util.Date;

/**
 * 汇率转换请求DTO
 * @author zxm
 * @since 2025-12-29
 */
@Data
public class ApiExchangeRateConvertRequest {

    /**
     * 金额
     */
    @NotNull(message = "金额不能为空")
    private BigDecimal amount;

    /**
     * 源币种代码
     */
    @NotBlank(message = "源币种不能为空")
    private String fromCurrency;

    /**
     * 目标币种代码
     */
    @NotBlank(message = "目标币种不能为空")
    private String toCurrency;

    /**
     * 交易日期（用于历史汇率查询）
     */
    private Date transactionDate;

    /**
     * 日期字符串（格式：yyyy-MM-dd），优先级低于transactionDate
     */
    private String date;

    /**
     * 是否需要返回汇率详情
     */
    private Boolean needDetail = false;

    /**
     * 业务场景标识
     */
    private String businessScene;

    /**
     * 业务ID
     */
    private String businessId;

    /**
     * 请求来源
     */
    private String source;

    /**
     * 请求ID（用于幂等性控制）
     */
    private String requestId;

    /**
     * 备注
     */
    private String remark;

    /**
     * 扩展字段（JSON格式）
     */
    private String extInfo;
}