package com.yd.base.service.service;

import com.yd.base.service.model.ExchangeRate;
import com.baomidou.mybatisplus.extension.service.IService;

import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.List;

/**
 * <p>
 * 汇率表 服务类
 * </p>
 *
 * @author zxm
 * @since 2025-12-29
 */
public interface IExchangeRateService extends IService<ExchangeRate> {

    /**
     * 根据币种对和日期查询汇率
     * @param baseCurrency 基础币种
     * @param targetCurrency 目标币种
     * @param effectiveDate 生效日期
     * @return 汇率记录
     */
    ExchangeRate getByCurrencyAndDate(String baseCurrency, String targetCurrency, LocalDate effectiveDate);

    /**
     * 根据币种对查询最新汇率
     * @param baseCurrency 基础币种
     * @param targetCurrency 目标币种
     * @return 最新汇率记录
     */
    ExchangeRate getLatestByCurrency(String baseCurrency, String targetCurrency);

    /**
     * 根据生效日期查询汇率列表
     * @param effectiveDate 生效日期
     * @return 汇率列表
     */
    List<ExchangeRate> getByEffectiveDate(LocalDate effectiveDate);

    /**
     * 查询所有有效的汇率记录
     * @return 汇率列表
     */
    List<ExchangeRate> getAllActiveRates();

    /**
     * 根据基础币种查询汇率
     * @param baseCurrency 基础币种
     * @return 汇率列表
     */
    List<ExchangeRate> getByBaseCurrency(String baseCurrency);

    /**
     * 根据目标币种查询汇率
     * @param targetCurrency 目标币种
     * @return 汇率列表
     */
    List<ExchangeRate> getByTargetCurrency(String targetCurrency);
}