package com.yd.base.feign.client.relobjectcategory;

import com.yd.base.feign.fallback.relobjectcategory.ApiRelObjectCategoryFeignFallbackFactory;
import com.yd.base.feign.request.relobjectcategory.ApiRelCategoryObjectListAddRequest;
import com.yd.base.feign.request.relobjectcategory.ApiRelObjectCategoryListAddRequest;
import com.yd.base.feign.request.relobjectcategory.ApiRelObjectCategoryQueryRequest;
import com.yd.base.feign.response.relobjectcategory.ApiRelObjectCategoryQueryResponse;
import com.yd.common.result.Result;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import java.util.List;

/**
 * 基础数据服务-对象分类关系信息Feign客户端
 */
@FeignClient(name = "yd-base-api",path = "/base/api/relObjectCategory",fallbackFactory = ApiRelObjectCategoryFeignFallbackFactory.class)
public interface ApiRelObjectCategoryFeignClient {

    /**
     * 查询-对象分类关系列表
     * @param request
     * @return
     */
    @PostMapping("/query")
    Result<List<ApiRelObjectCategoryQueryResponse>> query(@Validated @RequestBody ApiRelObjectCategoryQueryRequest request);

    /**
     * 添加-单个对象和分类列表关系
     * @param request
     * @return
     */
    @PostMapping("/add/relObjectCategoryList")
    Result addRelObjectCategoryList(@Validated @RequestBody ApiRelObjectCategoryListAddRequest request);

    /**
     * 添加-单个分类和对象列表关系
     * @param request
     * @return
     */
    @PostMapping("/add/relCategoryObjectList")
    Result addRelCategoryObjectList(@Validated @RequestBody ApiRelCategoryObjectListAddRequest request);
}
