package com.yd.base.service.dto;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

@Data
@Builder
@NoArgsConstructor
@AllArgsConstructor
public class CategoryDto {

    /**
     * 父id
     */
    private String pid;

    /**
     * 分类表唯一业务ID
     */
    private String categoryBizId;

    /**
     * 分类名称
     */
    private String name;

    /**
     * 是否排除当前categoryBizId
     */
    @Builder.Default
    private Boolean isExcludeMy = false;
}
